from django.shortcuts import render, redirect
from django.contrib import messages
import logging
from datetime import datetime, time
from django.contrib.auth.hashers import make_password, check_password

logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from .models import Users
from .forms import UserRegistrationForm, UserLoginForm


#### USER SESSIONS ======================================================================
def user_data_fxn(request):
    return {'username': request.session['username'], 'userid':request.session['userid'], 'name':request.session['name'], 'role':request.session['role']}

def login(request):
    try:
        del request.session['username']
        del request.session['name']
        del request.session['role']
        del request.session['userid']
    except:
        pass
    template_name = 'login.html'
    #form_class = ''

    if request.method == 'POST':
        username = request.POST.get('username').strip().lower()
        password = request.POST.get('password')
        user = Users.objects.filter(username=username).first()
        if user:
            if check_password(password, user.password):
                request.session['username'] = user.username
                request.session['userid'] = user.userid
                request.session['name'] = user.fname
                request.session['role'] = user.role
                user.last_login_date = datetime.now()
                user.save()
                messages.add_message(request, messages.SUCCESS, 'log in successfully')
                return redirect('/')
            messages.add_message(request, messages.ERROR, 'Username or Password Incorrect!!!')
            return redirect('/login')
        messages.add_message(request, messages.ERROR, 'Username or Password Incorrect!!!')
        return redirect('/login')

    else:
        return render(request, template_name, {})

import uuid
def register(request):
    if 'username' in request.session:
        if request.session['role'] == 'SUPERADMIN':
            template_name = 'register.html'
            form_class = UserRegistrationForm()

            if request.method == 'POST':
                form = UserRegistrationForm(request.POST)
                if form.is_valid():
                    obj = form.save(commit=False)
                    obj.password = make_password(request.POST.get('password'))
                    obj.userid = uuid.uuid4().hex
                    obj.save()
                    
                    logger.info(f"{request.POST.get('username')} Registered ")
                    messages.add_message(request, messages.SUCCESS, 'User registration was successful')
                    return redirect(f'/profile/{Users.objects.filter(username=request.POST.get("username")).first().id}')
                else:
                    messages.add_message(request, messages.ERROR, 'Network error!!!')
                    return redirect('/register')
            else:
                return render(request, template_name, {'form':form_class, 'user_data':user_data_fxn(request)})
        else:
            messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS OPERATION!!')
            return redirect('/')
    
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')



def profile(request, pk):
    if 'username' in request.session:
        template_name = 'profile.html'

        if request.method == 'POST':
            messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
            return redirect(f'/profile/{pk}')
        else:
            user_data = {'username' : request.session['username'], 'userid' : request.session['userid'], 'name': request.session['name'], 'role' : request.session['role']}
            user = Users.objects.get(pk=pk)
            if user.username.lower() == user_data['username'].lower():
                del user.password
                return render(request, template_name, {'user_data':user_data,'u':user})
            else:
                messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
                return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
        return redirect('/login')


def profile_userid(request):
    if 'username' in request.session:
        template_name = 'profile.html'

        if request.method == 'POST':
            pass
        else:
            userid = request.GET.get('userid')
            #user_data = {'username' : request.session['username'], 'userid' : request.session['userid'], 'name': request.session['name'], 'role' : request.session['role']}
            user = Users.objects.filter(userid=userid).first()
            if user.username.lower() == request.session['username'].lower():
                return redirect(f'/profile/{user.id}')
            else:
                messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
                return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
        return redirect('/login')


def change_password(request, pk):
    if 'username' in request.session:
        template_name = 'change_password.html'

        if request.method == 'POST':
            password1 = request.POST.get('password1')
            password2 = request.POST.get('password2')

            if password1 == password2:
                user = Users.objects.get(pk=pk)
                if user.username == request.session['username']:
                    old_pp = user.password
                    user.password = make_password(password1)
                    user.user_activities = f'password was changed on {datetime.now()} from {old_pp} \n\n {user.user_activities}'
                    user.save()
                    return redirect(f'/profile/{user.id}')
                else:
                    messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
                    return redirect('/login')
            else:
                messages.add_message(request, messages.ERROR, 'INCORRECT PASSWORD ENTERED!!')
                return redirect('/')
        else:
            user_data = {'uname' : request.session['username'], 'userid' : request.session['userid'], 'name': request.session['name'], 'role' : request.session['role']}
            return render(request, template_name, {'user_data':user_data})

    else:
        messages.add_message(request, messages.ERROR, 'NOT ALLOWED')
        return redirect('/login')




def reset_password(request):
    pass

def logout(request):
    try:
        del request.session['username']
        del request.session['name']
        del request.session['role']
        del request.session['userid']
    except:
        pass

    return redirect('/login')




