from django.db import models
import uuid

role_choices = (('SUPERADMIN','SUPERADMIN'),('MANAGER-ADMIN', 'MANAGER-ADMIN'), ('ADMIN','ADMIN'), ('SUPERUSER','SUPERUSER'), ('USER','USER'))

class Users(models.Model):
    fname = models.CharField(max_length=244)
    lname = models.CharField(max_length=244)
    username = models.CharField(max_length=244, unique=True)
    password = models.CharField(max_length=244)
    email = models.EmailField(unique=True)
    role = models.CharField(max_length=24, choices=role_choices)
    userid = models.CharField(max_length=24, default=uuid.uuid4().hex)
    datetime_registered = models.DateTimeField(auto_now_add=True)
    is_verified = models.BooleanField(default=False)
    user_activities = models.TextField(blank=True, null=True)
    last_login_date = models.DateTimeField(blank=True, null=True)

    def __str__(self):
        return '{} {}, {}'.format(self.fname, self.lname, self.role)
