from django import forms
from .models import Users

class UserLoginForm(forms.ModelForm):
    class Meta:
        model = Users
        widgets = {'password': forms.PasswordInput()}
        fields = ['username', 'password']


class UserRegistrationForm(forms.ModelForm):
    class Meta:
        model = Users
        widgets = {'password': forms.PasswordInput()}
        exclude = ['userid', 'datetime_registered', 'is_verified', 'last_login_date', 'user_activities']



class UserAdminForm(forms.ModelForm):
    class Meta:
        model = Users
        widgets = {'password': forms.PasswordInput()}
        exclude = []