from django.db import models

class LatestUpdateModel(models.Model):
    update = models.CharField(max_length=24)
    blend_number = models.CharField(max_length=8)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    def __str__(self) -> str:
        return f'{self.blend_number}'


product_type_Choices = (('',''), ('ALCOHOLIC', 'ALCOHOLIC'), ('NON-ALCOHOLIC', 'NON-ALCOHOLIC'))

class ProductListModel(models.Model):
    product_name_long = models.CharField(max_length=55, unique=True)
    product_name_short = models.CharField(max_length=6)
    product_type = models.CharField(max_length=15, choices=product_type_Choices, default='')
    product_category = models.CharField(max_length=24)
    comment = models.TextField(blank=True, null=True)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    def __str__(self) -> str:
        return self.product_name_long


class IngredientsListModel(models.Model):
    ingredient_name = models.CharField(max_length=244, unique=True)
    ingredient_description = models.TextField()
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    def __str__(self) -> str:
        return self.ingredient_name


