from django.shortcuts import redirect, render
from users.views import user_data_fxn
from blends.models import Blends

from django.contrib import messages
from django.conf import settings

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}

def scan_cam(request):
    template_name = 'scan_cam.html'

    if request.method == 'POST':
        pass
    else:
        return render(request, template_name, {'user_data':user_data_fxn(request)})


def scan_cam_res(request):
    template_name = 'scan_cam_res.html'

    if request.method == 'POST':
        pass
    else:
        return render(request, template_name, {'user_data':user_data_fxn(request)})


def search_mode(request):
    template_name = 'search_mode.html'

    if request.method == 'POST':
        blend_number = request.POST.get('blend_number')
        blend = Blends.objects.filter(blend_number__contains=blend_number).first()
        if blend:
            return redirect(f'/blend_info/{blend.id}')
        messages.error(request, 'Blend not found!!!')
        return redirect('/scan/search_mode')
    else:
        return render(request, template_name, {'user_data':user_data_fxn(request)})