from django.shortcuts import render, redirect
from django.forms.models import model_to_dict
from frontend.views import user_data_fxn
from django.http import HttpResponse, JsonResponse
from blends.models import Blends
from dispute.models import DisputeModel
#from frontend.views import check_get_appropriate_database
import csv, os, pandas, uuid

from .fxns import full_data_excel, datas_to_csv, datas_to_csv_v2

from django.core.files.storage import FileSystemStorage
from django.conf import settings

from datetime import datetime

BASE_DIR = settings.BASE_DIR
MEDIA_DIR = os.path.join(BASE_DIR, 'media')

from blends.models import Blends
from ingredients.models import Ingredients



def material_list(request):
    MATS = []
    #for mats in materials_Choices:
    #    MATS.append(mats[0])
    #return JsonResponse(MATS, safe=False)




def blend_report(request, pk):
    if 'username' in request.session:
        template_name = 'blend_report.html'

        if request.method == 'POST':
            pass
        else:
            blend = Blends.objects.get(pk=pk)
            ingr = Ingredients.objects.filter(blend=blend)
            return render(request, template_name, {'blend':blend, 'ingr':ingr, 'user_data':user_data_fxn(request)})
    else:
        return redirect('/login')



def blend_report_api(request):
    if 'username' in request.session:
        start_date=request.GET.get('start_date')
        end_date=request.GET.get('end_date')
        #res = full_data_excel(start_date=start_date, end_date=end_date)
        res = datas_to_csv(start_date=start_date, end_date=end_date)
        return JsonResponse(res, safe=False)
    else:
        return redirect('/login')


def blend_report_api_v2(request):
    if 'username' in request.session:
        start_date=request.GET.get('start_date')
        end_date=request.GET.get('end_date')
        product=request.POST.get('product')
        res = datas_to_csv_v2(product=product, start_date=start_date, end_date=end_date)
        return JsonResponse(res, safe=False)
    else:
        return redirect('/login')


def blend_report_date(request):
    if 'username' in request.session:
        template_name = 'blend_report_date.html'

        if request.method == 'POST':
            start_date=request.POST.get('start_date')
            end_date=request.POST.get('end_date')
            data = Blends.objects.filter(date_blended__range=[start_date, end_date]).order_by('product','-date_blended').values()
            return render(request, template_name, {'data':data, 'start_date':start_date, 'end_date':end_date, 'user_data':user_data_fxn(request)})
        else:
            return render(request, template_name, {'user_data':user_data_fxn(request)})
        
        #res = full_data_excel(start_date=start_date, end_date=end_date)
        #return JsonResponse(res, safe=False)
    else:
        return redirect('/login')

from service_worker.models import ProductListModel

def blend_report_date_product(request):
    if 'username' in request.session:
        template_name = 'blend_report_date_product.html'

        if request.method == 'POST':
            start_date=request.POST.get('start_date')
            end_date=request.POST.get('end_date')
            product=request.POST.get('product')
            data = Blends.objects.filter(product=product).filter(date_blended__range=[start_date, end_date]).order_by('-date_blended').values()
            return render(request, template_name, {'data':data, 'product':product, 'start_date':start_date, 'end_date':end_date, 'all_products':",".join([a.product_name_long for a in ProductListModel.objects.all()]), 'user_data':user_data_fxn(request)})
        else:
            return render(request, template_name, {'all_products':",".join([a.product_name_long for a in ProductListModel.objects.all()]), 'user_data':user_data_fxn(request)})
    else:
        return redirect('/login')

