from blends.models import Blends

from dispute.models import DisputeModel
from django.forms.models import model_to_dict

import pandas
import os
import uuid

from django.core.files.storage import FileSystemStorage
from django.conf import settings

BASE_DIR = settings.BASE_DIR
MEDIA_DIR = os.path.join(BASE_DIR, 'media')



###EXPORT QUERYSET TO EXCEL ======================================================================================
def full_data_excel(start_date, end_date):
    data = {}
    raw = Blends.objects.filter(date_blended__range=[start_date, end_date])#.values('reference', 'material', 'material_description', 'sampled_by', 'vehicle_number', 'quantity', 'supplier', 'date_sampled', 'result', 'technologist', 'status', 'comment', 'created_by', 'username', 'datetime', 'has_dispute', 'dispute_status', 'checked_by', 'checked_comment', 'checked_by_date')
    df_raw = pandas.DataFrame(data=raw.values())#'reference', 'material', 'material_description', 'sampled_by', 'vehicle_number', 'quantity', 'supplier', 'date_sampled', 'result', 'technologist', 'status', 'comment', 'created_by', 'username', 'datetime', 'has_dispute', 'dispute_status', 'checked_by', 'checked_comment', 'checked_by_date'), index=[0])
    
    df_raw.drop(['forms_images_uploaded', 'disputes_status_list'], axis=1, inplace=True)
    df_raw['date_blended'] = df_raw['date_blended'].apply(lambda a: pandas.to_datetime(a).date())#pandas.to_datetime(df_raw['checked_by_date'], errors='coerce')#df_raw['checked_by_date'].dt.tz_localize(None)
    df_raw['datetime'] = df_raw['datetime'].apply(lambda a: pandas.to_datetime(a).date()) #df_raw['datetime'].dt.tz_localize(None)
    df_raw['date_sampled'] = df_raw['date_sampled'].apply(lambda a: pandas.to_datetime(a).date())#pandas.to_datetime(df_raw['date_sampled'], errors='coerce')#df_raw['date_sampled'].dt.tz_localize(None)
    df_raw['checked_by_date'] = df_raw['checked_by_date'].apply(lambda a: pandas.to_datetime(a).date())#pandas.to_datetime(df_raw['date_sampled'], errors='coerce')#df_raw['date_sampled'].dt.tz_localize(None)
    df_raw['bottled_by_date'] = df_raw['bottled_by_date'].apply(lambda a: pandas.to_datetime(a).date())#pandas.to_datetime(df_raw['date_sampled'], errors='coerce')#df_raw['date_sampled'].dt.tz_localize(None)
    #data['Raw Materials'] = df_raw
    
    unique_materials = df_raw['blend_number'].unique()

    for u in list(unique_materials):
        u_q = raw.filter(blend_number=u)
        u_vals = u_q.values()
        for u1 in u_q:
            #if u1.material_info.dispute_status !='':
            disputes = DisputeModel.objects.filter(blend=Blends.objects.filter(blend_number=u1).first()).values_list('dispute')
            #u_vals['dispute'] = disputes

        dff = pandas.DataFrame(data=u_vals)

        #dff['date_sampled'] = dff['date_sampled'].apply(lambda a: pandas.to_datetime(a).date())
        dff['datetime'] = dff['datetime'].apply(lambda a: pandas.to_datetime(a).date())
        dff['checked_by_date'] = dff['checked_by_date'].apply(lambda a: pandas.to_datetime(a).date())
        data[u] = dff

    path1 = os.path.join(MEDIA_DIR, f'{uuid.uuid4().hex[:5]}')
    os.makedirs(path1, exist_ok=True)
    output_file_path = os.path.join(path1, f'full-{start_date}-to-{end_date}.xlsx')

    writer = pandas.ExcelWriter(output_file_path, engine='xlsxwriter')
    for k,v in data.items():
        v.to_excel(writer, sheet_name=k)
    writer.save()
    #return JsonResponse({'file_link':output_file_path}, safe=False)
    return output_file_path.split('media')[1]

def build_file_path(start_date, end_date):
    path1 = os.path.join(MEDIA_DIR, f'{uuid.uuid4().hex[:5]}')
    os.makedirs(path1, exist_ok=True)
    output_file_path = os.path.join(path1, f'full-{start_date}-to-{end_date}.csv')
    return output_file_path


def datas_to_csv(start_date, end_date):
    raw = Blends.objects.filter(date_blended__range=[start_date, end_date])
    df_raw = pandas.DataFrame(data=raw.values())
    df_raw.drop(['forms_images_uploaded', 'disputes_status_list'], axis=1, inplace=True)
    output = build_file_path(start_date, end_date)
    df_raw.to_csv(output)
    return output


def build_file_path_v2(product, start_date, end_date):
    path1 = os.path.join(MEDIA_DIR, f'{uuid.uuid4().hex[:5]}')
    os.makedirs(path1, exist_ok=True)
    output_file_path = os.path.join(path1, f'product-{product.split(" ")[0]}-full-{start_date}-to-{end_date}.csv')
    return output_file_path

def datas_to_csv_v2(product, start_date, end_date):
    raw = Blends.objects.filter(product=product).filter(date_blended__range=[start_date, end_date]).order_by('-date_blended').values()
    df_raw = pandas.DataFrame(data=raw.values())
    df_raw.drop(['forms_images_uploaded', 'disputes_status_list'], axis=1, inplace=True)
    output = build_file_path_v2(product, start_date, end_date)
    df_raw.to_csv(output)
    return output
