from django.db import models
from blends.models import Blends
from service_worker.models import IngredientsListModel

all_ingr = IngredientsListModel.objects.all().order_by('ingredient_name')
ingredients_Choices=[(a.ingredient_name.upper(), a.ingredient_name.upper()) for a in all_ingr]

class Ingredients(models.Model):
    blend = models.ForeignKey(Blends, on_delete=models.CASCADE)
    blend_number = models.CharField(max_length=24)
    ingredient = models.CharField(max_length=24, choices=ingredients_Choices)
    quantity = models.CharField(max_length=24)
    supplier = models.CharField(max_length=24)
    ingredient_code = models.CharField(max_length=55)
    date_of_supply = models.DateField()

    username = models.CharField(max_length=55)
    datetime = models.DateTimeField(auto_now_add=True)



    def __str__(self) -> str:
        return f"{self.blend_number}, Ingredient = {self.ingredient}"
