from django.forms import ModelForm
from .models import Ingredients

# Create the form class.
class IngredientsForm(ModelForm):
    def __init__(self, *args, **kwargs):
        super(IngredientsForm, self).__init__(*args, **kwargs)
        self.fields['date_of_supply'].widget.attrs['type'] = 'date'

    class Meta:
        model = Ingredients
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['blend','blend_number', 'username', 'datetime']



class IngredientsAdminForm(ModelForm):
    def __init__(self, *args, **kwargs):
        super(IngredientsAdminForm, self).__init__(*args, **kwargs)
        self.fields['date_of_supply'].widget.attrs['type'] = 'date'

    class Meta:
        model = Ingredients
        exclude = []