from django.shortcuts import render, redirect
import logging

from django.contrib import messages
from django.conf import settings

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from blends.models import Blends
from blends.forms import BlendsForm
from ingredients.models import Ingredients

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn

from dispute.models import DisputeModel
from service_worker.models import ProductListModel

def update_blend(request, id):
    if 'username' in request.session:
        template_name = "update_blend.html"
        blend = Blends.objects.get(id=id)

        if blend.status != 'BLENDED':
            messages.error(request, f'Blend already Checked by CBMO cannot be edited!!!')
            return redirect(f'/blend_info/{id}/')

        if request.method == 'POST':
            form = BlendsForm(request.POST, instance=blend)
            if form.is_valid():
                form.save()
                LatestUpdatesfxn(update=f"Blend {blend.blend_number}, Tank {blend.tank_number}, Product {blend.product} have been created", blend_number={blend.blend_number}, created_by=request.session['username'])
                messages.success(request, f'Blend {blend.blend_number} created Updated')
                return redirect(f'/blend_info/{id}/')
            messages.error(request, f'Connection Error, Blend Not Updated')
            return redirect(f'/blend_info/{id}/')
        else:
            form = BlendsForm(instance=blend)
            return render(request, template_name, {'form':form, 'blend':blend, 'user_data':user_data_fxn(request), 'all_products':",".join([a.product_name_long for a in ProductListModel.objects.all()])})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')