from django.shortcuts import render, redirect
from simple_search import search_filter
from datetime import datetime, time
import logging

from django.core.serializers.json import DjangoJSONEncoder
from django.forms.models import model_to_dict
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from blends.models import Blends
from ingredients.models import Ingredients

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn

from dispute.models import DisputeModel


###PAGINATOR FUNCTION========================================================================
def paginator(request, queryset):
    #dataLS = get_all_data_LSR(300)#dashboard max setting
    page = request.GET.get('page', 1)
    paginator = Paginator(queryset, 30)
    
    try:
        data = paginator.page(page)
    except PageNotAnInteger:
        data = paginator.page(1)
    except EmptyPage:
        data = paginator.page(paginator.num_pages)
    return data

##DASHBOARD ======================================================================================
def dashboard(request):
    if 'username' in request.session:
        template_name = 'dashboard.html'
        template_name_search = 'search_dashboard.html'

        if request.method == "POST":
            search_query = request.POST.get('search')
            search_fields = ['alcohol_source', 'alcohol_strength', 'alcohol_tasting_score', 'blend_number', 'blend_number_2', 'blending_inspector', 'bottled_by_date', 'bottled_comment', 'bottled_recorded_by', 'checked_by', 'checked_by_date', 'checked_comment', 'comment', 'date_blended', 'datetime', 'demin_water_calcium', 'demin_water_caustic_code', 'demin_water_chlorine', 'demin_water_conductivity', 'demin_water_hcl_code', 'demin_water_iron', 'demin_water_ph', 'demin_water_plant', 'dispute_status', 'disputes_status_list', 'forms_images_uploaded', 'hygiene','product', 'product_alcoholic_strength', 'product_brix', 'product_color', 'product_conductivity', 'product_ph', 'product_tasting_result', 'product_type', 'result', 'status', 'sugar_brix', 'sugar_conductivity', 'sugar_pass_or_fail', 'sugar_ph', 'sugar_temperature', 'tank_number', 'username', 'volume_in_ltr']
            f = search_filter(search_fields, search_query)
            filtered = Blends.objects.filter(f)
            return render(request, template_name_search, {'data':filtered, 'search_query':search_query, 'user_data':user_data_fxn(request)})
        else:
            data = Blends.objects.all().order_by('-id')
            #data = paginator(request, queryset=B)
            return render(request, template_name, {'data':data, 'user_data':user_data_fxn(request)})
    else:
        return redirect('/login')

def queryset_dictionary_ser(queryset):
    out = {}
    for k,v in queryset.items():
        out[k.replace('_', ' ').upper()] = v if v != '' else 'NA'
    try:
        del out['ID']
    except:
        pass
    return out



def blend_info(request, pk):
    if 'username' in request.session:
        template_name = 'blend_info.html'

        if request.method == "POST":
            pass
        else:
            data = Blends.objects.filter(pk=pk)
            if data.first():
                data_ingredients = Ingredients.objects.filter(blend=data.first())
                disputes = DisputeModel.objects.filter(blend=data.first())
                return render(request, template_name, {'d':data.first(), 'disputes':disputes, 'd1':queryset_dictionary_ser(data.values()[0]), 'd2':data_ingredients, 'user_data':user_data_fxn(request)})
            messages.error(request, 'Blend number not found!!!')
            return redirect('/')
    else:
        return redirect('/login')


def blend_info2(request):
    if 'username' in request.session:
        template_name = 'blend_info.html'

        if request.method == "POST":
            pass
        else:
            blend_number = request.GET.get('ref')
            data = Blends.objects.filter(blend_number=blend_number)
            if data.first():
                data_ingredients = Ingredients.objects.filter(blend=data.first())
                disputes = DisputeModel.objects.filter(blend=data.first())
                return render(request, template_name, {'d':data.first(), 'disputes':disputes, 'd1':queryset_dictionary_ser(data.values()[0]), 'd2':data_ingredients, 'user_data':user_data_fxn(request)})
            messages.error(request, 'Blend number not found!!!')
            return redirect('/')
    else:
        return redirect('/login')


##### ADD INGREDIENT TO BLEND ===================================================================
from ingredients.forms import IngredientsForm


def add_ingredient(request):
    if 'username' in request.session:
        template_name = 'add_ingredient.html'
        form_class = IngredientsForm()

        form = IngredientsForm(request.POST or None)

        if request.method == "POST":
            blend_number = request.POST.get('blend_number')
            blend = Blends.objects.filter(blend_number=blend_number).first()
            if blend.status != 'BLENDED' and request.session['role'] == 'USER':
                messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
                return redirect(f'/blend_info/{blend.id}')

            if form.is_valid():
                obj = form.save(commit=False)
                obj.blend = blend
                obj.blend_number = blend_number
                obj.username = request.session['username']
                obj.save()
                LatestUpdatesfxn(update=f"Ingredient {obj.ingredient} added to Blend {blend_number}, Tank {blend.tank_number}, Product {blend.product}", blend_number=blend_number, created_by=request.session['username'])
                messages.success(request, 'Ingredient have been added to the blend!!!')
                return redirect(f'/blend_info/?ref={request.POST.get("blend_number")}')
            else:
                messages.error(request, 'Form data is incomplete')
                return redirect(f'/blend_info/?ref={request.POST.get("blend_number")}')
        else:
            blend_number = request.GET.get('ref')
            if blend_number:
                data = Blends.objects.filter(blend_number=blend_number).first()
                ingr = Ingredients.objects.filter(blend=data)
                return render(request, template_name, {'d':data, 'i':ingr, 'form':form_class, 'user_data':user_data_fxn(request)})
            messages.error(request, 'Blend number not found!!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')


####VIEW INGREDIENT INFO START============================================================================================
def ingredient_info(request, pk):
    if 'username' in request.session:
        template_name = 'ingredient_info.html'

        if request.method == "POST":
            pass
        else:
            ingredient = Ingredients.objects.get(pk=pk)
            if ingredient:
                return render(request, template_name, {'d':ingredient, 'user_data':user_data_fxn(request)})
            messages.error(request, 'Blend number not found!!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')
####VIEW INGREDIENT INFO ENDS============================================================================================


#### BLEND DESPATCH START ===============================================================================================
def despatch(request, pk):
    if 'username' in request.session:
        template_name = 'despatch.html'

        if request.method == "POST":
            pass
        else:
            bld = Blends.objects.get(pk=pk)
            if bld:
                return render(request, template_name, {'bld':bld, 'user_data':user_data_fxn(request)})
            messages.error(request, 'Blend number not found!!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')

#### BLEND DESPATCH ENDS ===============================================================================================


####CBMO APPROVAL START===================================================================================================
def blend_cbmo_approval(request):
    if 'username' in request.session:
        if request.session['role'] == 'SUPERADMIN' or request.session['role'] == 'ADMIN':

            if request.method == "POST":
                matid = request.POST.get('matid')
                checked_comment = request.POST.get('checked_comment')
                pass_fail = request.POST.get('pass_fail')
                bld = Blends.objects.get(id=int(matid))
                if bld.status != 'BLENDED' or bld.result != 'PENDING':
                    messages.add_message(request, messages.ERROR, f'Blend {bld.blend_number} Already checked by CBMO')
                    return redirect(f'/blend_info/{bld.id}')

                bld.is_checked = True
                bld.checked_comment = checked_comment
                bld.checked_by = request.session["username"]
                bld.checked_by_date = datetime.now()
                bld.status = 'CHECKED'
                bld.result = pass_fail.upper()
                bld.save()

                ###LATEST UPDATE========================================================
                LatestUpdatesfxn(update=f"Blend {bld.blend_number} {pass_fail.upper()} by CBMO {request.session['username']} ", blend_number=bld.blend_number, created_by = request.session["username"])
                messages.add_message(request, messages.SUCCESS, f'Blend {bld.blend_number} {pass_fail.upper()} by CBMO')
                return redirect(f'/blend_info/{bld.id}')
            else:
                return redirect('/')
        
        else:
            messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED!!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')
####CBMO APPROVAL ENDS============================================================================================


#### BLEND BOTTLED COMPLETELY FORM ======================================================================
def blend_bottled_completed(request):
    if 'username' in request.session:
        if request.session['role'] == 'SUPERADMIN' or request.session['role'] == 'ADMIN':
            if request.method == 'POST':
                bottled_yes_no = request.POST.get('bottled_yes_no')
                bottled_comment = request.POST.get('bottled_comment')
                matid = request.POST.get('matid')
                bld = Blends.objects.get(id=int(matid))

                if bottled_yes_no == 'NO':
                    return redirect(f'/blend_info/{bld.id}')
                
                if bld.status != 'CHECKED':
                    messages.add_message(request, messages.ERROR, f'Blend {bld.blend_number} have not been checked by CBMO')
                    return redirect(f'/blend_info/{bld.id}')

                bld.is_bottled = True
                bld.bottled_comment = bottled_comment
                bld.bottled_recorded_by = request.session["username"]
                bld.bottled_by_date = datetime.now()
                bld.save()

                ###LATEST UPDATE========================================================
                LatestUpdatesfxn(update=f"Blend {bld.blend_number} have been bottled", blend_number=bld.blend_number, created_by = request.session["username"])
                messages.add_message(request, messages.SUCCESS, f'Blend {bld.blend_number} have been bottled')
                return redirect(f'/blend_info/{bld.id}')
            else:
                return redirect('/')
        else:
            messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED!!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/')
#### BLEND BOTTLED COMPLETELY FORM ======================================================================

from django.views.decorators.csrf import csrf_exempt
from service_worker.models import ProductListModel
from service_worker.forms import ProductListForm

@csrf_exempt
def create_new_product(request):
    if 'username' in request.session:
        template_name = 'create_new_product.html'
        form_class = ProductListForm()
        
        form = ProductListForm(request.POST or None)

        if request.method == "POST":
            
            if form.is_valid():
                obj = form.save(commit=False)
                obj.created_by = request.session['username']
                obj.save()
                LatestUpdatesfxn(update=f"New product {request.POST.get('product_name_short')} have been added", blend_number='', created_by=request.session['username'])
                messages.success(request, f"Product {request.POST.get('product_name_short')} have been added to the blend!!!")
                return redirect('/create_new_product_form/')
            else:
                messages.error(request, 'Form data is incomplete')
                return redirect('/create_new_product_form/')
        else:
            prods = ProductListModel.objects.all().order_by('product_type','product_name_long')
            return render(request, template_name, {'p':prods, 'form':form_class, 'user_data':user_data_fxn(request)})

    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')



### create_new_ingredient ++++++++++=====================================================================
from service_worker.forms import IngredientsListForm
from service_worker.models import IngredientsListModel

@csrf_exempt
def create_new_ingredient(request):
    if 'username' in request.session:
        template_name = 'create_new_ingredient.html'
        form_class = IngredientsListForm()
        
        form = IngredientsListForm(request.POST or None)

        if request.method == "POST":
            if form.is_valid():
                obj = form.save(commit=False)
                obj.created_by = request.session['username']
                obj.save()
                LatestUpdatesfxn(update=f"New ingredient {request.POST.get('ingredient_name')} have been created", blend_number='', created_by=request.session['username'])
                messages.success(request, f"New ingredient {request.POST.get('ingredient_name')} have been created")
                return redirect('/create_new_ingredient_form/')
            else:
                messages.error(request, 'Form data is incomplete')
                return redirect('/create_new_ingredient_form/')
        else:
            ingr = IngredientsListModel.objects.all().order_by('ingredient_name')
            return render(request, template_name, {'p':ingr, 'form':form_class, 'user_data':user_data_fxn(request)})

    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')




def blend_approval_page(request):
    if 'username' in request.session:

        if request.session['role'] == 'SUPERADMIN' or request.session['role'] == 'MANAGER-ADMIN':
            if request.method == 'POST':
                matid = request.POST.get('matid')
                approval_comment = request.POST.get('approval_comment')
                pass_fail = request.POST.get('pass_fail')

                if pass_fail == 'YES':
                    blend = Blends.objects.get(pk=int(matid))
                    if blend:
                        blend.is_approved = True
                        blend.approver_comment = approval_comment
                        blend.approved_by = request.session['username']
                        blend.approval_date = datetime.now()
                        blend.status = 'APPROVED'
                        blend.save()
                        LatestUpdatesfxn(update=f"Blend {blend.blend_number} have been Approved", blend_number=blend.blend_number, created_by=request.session['username'])
                        messages.add_message(request, messages.SUCCESS, f'BLEND {blend.blend_number} HAVE BEEN APPROVED')
                        return redirect(f'/blend_info/{matid}')
                    messages.add_message(request, messages.ERROR, f'BLEND NOT FOUND')
                    return redirect(f'/blend_info/{matid}')
                messages.add_message(request, messages.ERROR, f'BLEND {blend.blend_number} NOT APPROVED')
                return redirect(f'/blend_info/{matid}')
            
            else:
                messages.add_message(request, messages.ERROR, 'NOT ALLOWED!!')
                return redirect(f'/blend_info/{matid}')
        else:
            messages.add_message(request, messages.ERROR, 'NOT ALLOWED!!')
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'NOT AUTHENTICATED!!!')
        return redirect('/login') 




#### FILE STORAGE SYSTEM FUNCTIONS +++++++++++++++++++++++===========================================
from django.core.files.storage import FileSystemStorage
from django.conf import settings
import uuid
import shutil
import os

BASE_DIR = settings.BASE_DIR
MEDIA_DIR = os.path.join(BASE_DIR, 'media')


def file_upload(request):
    if 'username' in request.session:
        if request.method == "POST":
            idd = request.POST.get('matidd')
            file_name = request.POST.get('file_name')
            file_uploaded = request.FILES['myfile']

            material = []#RawMaterialModel.objects.get(id=int(idd))
            if file_uploaded:
                fs = FileSystemStorage()

                path1 = os.path.join(MEDIA_DIR, material.reference)

                os.makedirs(path1, exist_ok=True)

                file_new_name = os.path.join(path1, f"{file_name}.{file_uploaded.name.split('.')[-1]}")
                
                filename = fs.save(file_new_name, file_uploaded)

                if material.forms_images_uploaded:
                    material.forms_images_uploaded = f"{file_new_name}||{request.session['username']},{material.forms_images_uploaded}"
                else:
                    material.forms_images_uploaded = f"{file_new_name}||{request.session['username']}"

                material.save()

                ###LATEST UPDATE==================================
                #LatestUpdatesfxn(title=f'{file_name} uploaded', mssg=f'Document {file_name} : {material.reference} uploaded by {request.session["username"]}', reference=material.reference, created_by=request.session["username"])
                
                messages.add_message(request, messages.SUCCESS, f'{file_name} Upload successful')
                return redirect(f'/material_info/?ref={material.reference}')

            else:
                messages.add_message(request, messages.ERROR, f'{file_name} not found')
                return redirect(f'/material_info/?ref={material.reference}')
        else:
            return redirect(f'/material_info/?ref={material.reference}')

    else:
        messages.add_message(request, messages.ERROR, 'NOT AUTHENTICATED')
        return redirect('/login')   
    
