from django.urls import path
from . import views
from users.views import login, register, profile, profile_userid, change_password, logout
from .views_update import update_blend

urlpatterns = [
    path('', views.dashboard),
    path('dashboard/', views.dashboard),
    path('blend_info/', views.blend_info2),
    path('blend_info/<int:pk>/', views.blend_info),
    path('blend_cbmo_approval/', views.blend_cbmo_approval),
    path('add_ingredient/', views.add_ingredient),
    path('ingredient_info/<int:pk>/', views.ingredient_info),
    path('despatch/<int:pk>/', views.despatch),
    path('blend_bottled_completed/', views.blend_bottled_completed),

    path('blend_approval_page/', views.blend_approval_page),

    path('login/', login),
    path('register/', register),
    path('profile/', profile_userid),
    path('profile/<int:pk>/', profile),
    path('change_password/<int:pk>/', change_password),
    path('logout/', logout),

    path('create_new_product_form/', views.create_new_product),
    path('create_new_ingredient_form/', views.create_new_ingredient),

    path('update_blend/<int:id>/', update_blend)


]