from bson import is_valid
from django.shortcuts import render, redirect
from .models import DisputeModel

from service_worker.views import LatestUpdatesfxn
from django.contrib import messages

import logging
from datetime import datetime

from frontend.views import paginator
from users.views import user_data_fxn
from django.db.models import Q
from service_worker.views import LatestUpdatesfxn

from blends.models import Blends

logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from .forms import DisputeOpenForm, DisputeCloseForm


def dispute_dashboard(request):
    if 'username' in request.session:
        template_name = 'dispute_dashboard.html'

        if request.method == 'POST':
            return redirect('/dispute/')
        else:
            open_disputes = DisputeModel.objects.filter(status='OPEN').order_by('-id')
            R = paginator(request, queryset=open_disputes)
            return render(request, template_name, {'disputes':R, 'user_data':user_data_fxn(request)})
    else:
        return redirect('/login')


def create_dispute(request):
    if 'username' in request.session:
        template_name = 'create_dispute.html'
        form = DisputeOpenForm(request.POST or None)

        if request.method == 'POST':
            if form.is_valid():
                blend_number = request.POST.get('blend_number')
                R = Blends.objects.filter(blend_number=blend_number).first()
                obj = form.save(commit=False)
                obj.blend = R
                obj.created_by = request.session['username']
                obj.save()
                D = DisputeModel.objects.last()
                R.has_dispute = True
                R.dispute_status = 'open'
                if R.disputes_status_list != '':
                    R.disputes_status_list = f'{D.id},{R.disputes_status_list}'
                else:
                    R.disputes_status_list = f'{D.id}'
                R.save()

                ###LATEST UPDATE==================================
                LatestUpdatesfxn(update=f"Dispute raised on Blend {blend_number}", blend_number=blend_number, created_by=request.session['username'])
                
                logger.info("f'Dispute raised on Blend {blend_number}' on {datetime.now()}")
                messages.add_message(request, messages.SUCCESS, f'Dispute raised on Blend {blend_number}')
                return redirect(f'/blend_info/{R.id}')

            messages.add_message(request, messages.ERROR, 'Form Data Incomplete')
            return redirect(f'/dispute/create_dispute/?ref={R.blend_number}')

        else:
            blend_number = request.GET.get('ref')
            B = Blends.objects.filter(blend_number=blend_number).first()
            disputes = DisputeModel.objects.filter(blend=B)
            return render(request, template_name, {'d':B, 'disputes':disputes, 'form':form, 'user_data':user_data_fxn(request)})
    else:
        return redirect('/login')



def close_dispute(request, id):
    if 'username' in request.session:
        template_name = 'close_dispute.html'
        form = DisputeCloseForm(request.POST or None)

        if request.method == 'POST':
            close_comment = request.POST.get('close_comment')
            
            D = DisputeModel.objects.get(id=id)
            D.status = 'CLOSED'
            D.closing_comment = close_comment
            D.closed_by = request.session['username']
            D.datetime_closed = datetime.now()
            D.save()
            
            R = D.blend
            disputes_list = R.disputes_status_list.split(',')
            disputes_list_lg = []
            for d in disputes_list:
                if d !='None':
                    disputes_list_lg.append(DisputeModel.objects.get(id=int(d)).status)
            if 'OPEN' in disputes_list_lg:
                R.dispute_status = 'open'
            else:
                R.dispute_status = 'closed'
            R.save()

            ###LATEST UPDATE==================================
            LatestUpdatesfxn(update=f"Dispute on Blend {R.blend_number} have been closed by {request.session['username']}", blend_number=R.blend_number, created_by=request.session['username'])
            
            logger.info("Dispute on {} have been closed".format(R.blend_number))
            messages.add_message(request, messages.SUCCESS, "Dispute on {} have been closed".format(R.blend_number))

            return redirect(f'/blend_info/{R.id}')
        else:
            D = DisputeModel.objects.get(id=id)
            if D:
                disputes = DisputeModel.objects.filter(blend=D.blend)
                return render(request, template_name, {'d':D.blend, 'dispute':D, 'disputes':disputes, 'form':form, 'user_data':user_data_fxn(request)})
            else:
                messages.add_message(request, messages.ERROR, "Dispute not found")
                return redirect('/dispute/dispute_dashboard/')
    else:
        return redirect('/login')
