from django.db import models
from blends.models import Blends

disputes_Choices = (("SAMPLING","SAMPLING"), ("ANALYSIS","ANALYSIS"), ("CHECKING","CHECKING"), ("APPROVAL","APPROVAL"), ("USAGE","USAGE"))
status_Choices = (("OPEN","OPEN"), ("CLOSED","CLOSED"))

class DisputeModel(models.Model):
    dispute = models.CharField(max_length=255)
    blend = models.ForeignKey(Blends, on_delete = models.CASCADE)
    area_of_dispute = models.CharField(max_length=12, choices=disputes_Choices, default="SAMPLING")
    status = models.CharField(max_length=12, choices=status_Choices, default="OPEN")
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    closing_comment = models.TextField(blank=True, null=True)
    closed_by = models.CharField(max_length=50, blank=True, null=True)
    datetime_closed = models.DateTimeField(blank=True, null=True)


    def __str__(self):
        return f"reference = {self.blend.blend_number}, title = {self.area_of_dispute}"
