from bson import is_valid
from django.shortcuts import render, redirect
from .models import Blends
from .forms import BlendsForm
from service_worker.models import ProductListModel

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}

import logging, datetime
logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn


def blend_number_generator(product):
    last_blend = Blends.objects.filter(product=product).last()
    year = datetime.datetime.now().year#.strftime('%y')
    if last_blend:
        return [str(int(last_blend.blend_number) + 1).zfill(5), f"{last_blend.blend_number_2[:-7]}{str(year)[2:]}{int(last_blend.blend_number_2[-5:]) + 1}"]
    else:
        prod = ProductListModel.objects.filter(product_name_long=product).first()
        return ['00001', f"{prod.product_name_short}{str(year)[2:]}0001"]



def create_blend_form(request):
    if 'username' in request.session:
        template_name = 'create_blend_form.html'

        form = BlendsForm(request.POST or None)

        if request.method == 'POST':
            if Blends.objects.filter(blend_number=request.POST.get('blend_number')).first():
                messages.error(request, 'Blend number already exists')
                return redirect('/blend/create_blend_form/')
                
            if form.is_valid():
                print(form)
                obj = form.save(commit=False)
                obj.username = request.session['username']
                obj.save()
                LatestUpdatesfxn(update=f"Blend {request.POST.get('blend_number')}, Tank {request.POST.get('tank_number')}, Product {request.POST.get('product')} have been created", blend_number=request.POST.get('blend_number'), created_by=request.session['username'])
                messages.success(request, 'Blend created successfully')
                return redirect('/')
            else:
                messages.error(request, 'Blend number already in the system!!')
                return redirect('/blend/create_blend_form/')

        else:
            return render(request, template_name, {'form':form, 'user_data':user_data_fxn(request), 'all_products':",".join([a.product_name_long for a in ProductListModel.objects.all()])})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')
