from django.db import models
from django.utils import timezone
from service_worker.models import ProductListModel
from django.utils.functional import lazy



def get_all_products():
    product_Choices = []
    all_product = ProductListModel.objects.all()
    for a in all_product:
        product_Choices.append((a.product_name_long, a.product_name_long))
    return product_Choices


product_Choices = []
all_product = ProductListModel.objects.all()
for a in all_product:
    product_Choices.append((a.product_name_long, a.product_name_long))


results_Choices = (('PENDING', 'PENDING'), ("PASS","PASS"), ("FAIL","FAIL"), ("OTHER","OTHER"))
status_Choices = (("BLENDED","BLENDED"), ("CHECKED","CHECKED"), ("APPROVED","APPROVED"), ("BOTTLED","BOTTLED"))
dispute_Choices = (('',''), ('open', 'open'), ('closed', 'closed'))
pass_fail_Choices = (('',''), ('PASS', 'PASS'), ('FAIL', 'FAIL'))
product_type_Choices = (('',''), ('ALCOHOLIC', 'ALCOHOLIC'), ('NON-ALCOHOLIC', 'NON-ALCOHOLIC'))


class Blends(models.Model):
    product = models.CharField(max_length=55, choices=[(a.product_name_long, a.product_name_long) for a in ProductListModel.objects.all()])
    product_type = models.CharField(max_length=55, choices=product_type_Choices, default='')
    blend_number = models.CharField(max_length=24, unique=True)
    blend_number_2 = models.CharField(max_length=24, unique=True)
    date_blended = models.DateField(default=timezone.now)
    tank_number = models.IntegerField()
    volume_in_ltr = models.FloatField()

    alcohol_source = models.CharField(max_length=55, null=True, blank=True)
    alcohol_strength = models.FloatField(null=True, blank=True)
    alcohol_tasting_score = models.CharField(max_length=55, null=True, blank=True)

    demin_water_plant = models.CharField(max_length=25)
    demin_water_ph = models.FloatField()
    demin_water_conductivity = models.FloatField()
    demin_water_chlorine = models.CharField(max_length=25)
    demin_water_iron = models.CharField(max_length=25)
    demin_water_calcium = models.CharField(max_length=25)
    demin_water_caustic_code = models.CharField(max_length=25)
    demin_water_hcl_code = models.CharField(max_length=25)

    sugar_brix = models.FloatField(null=True, blank=True)
    sugar_ph = models.FloatField(null=True, blank=True)
    sugar_conductivity = models.FloatField(null=True, blank=True)
    sugar_temperature = models.FloatField(null=True, blank=True)
    sugar_pass_or_fail = models.CharField(max_length=25, choices=pass_fail_Choices, null=True, blank=True, default="")

    hygiene = models.CharField(max_length=25, choices=pass_fail_Choices, default="")

    product_alcoholic_strength = models.FloatField(null=True, blank=True)
    product_color = models.FloatField(null=True, blank=True)
    product_ph = models.FloatField(null=True, blank=True)
    product_conductivity = models.FloatField(null=True, blank=True)
    product_tasting_result = models.CharField(max_length=24, null=True, blank=True)
    product_brix = models.FloatField(null=True, blank=True)

    result = models.CharField(max_length=25, choices=results_Choices, default="PENDING")
    status = models.CharField(max_length=25, choices=status_Choices, default="BLENDED")
    comment = models.TextField(default='', null=True, blank=True)

    blending_inspector = models.CharField(max_length=55)

    username = models.CharField(max_length=55)
    datetime = models.DateTimeField(auto_now_add=True)

    has_dispute = models.BooleanField(default=False)
    dispute_status = models.CharField(max_length=12, null=True, blank=True, choices=dispute_Choices, default='')
    disputes_status_list = models.CharField(max_length=255, null=True, blank=True)

    is_checked = models.BooleanField(default=False)
    checked_comment = models.TextField(default='', null=True, blank=True)
    checked_by = models.CharField(max_length=25, null=True, blank=True)
    checked_by_date = models.DateTimeField(null=True, blank=True)

    is_approved = models.BooleanField(default=False)
    approver_comment = models.TextField(default='', null=True, blank=True)
    approved_by = models.CharField(max_length=25, null=True, blank=True)
    approval_date = models.DateTimeField(null=True, blank=True)

    is_bottled = models.BooleanField(default=False)
    bottled_comment = models.TextField(default='', null=True, blank=True)
    bottled_recorded_by = models.CharField(max_length=25, null=True, blank=True)
    bottled_by_date = models.DateTimeField(null=True, blank=True)

    forms_images_uploaded = models.TextField(blank=True, null=True)##file_link||uploaded_by, file_link||uploaded_by

    def __init__(self, *args, **kwargs):
        super(Blends, self).__init__(*args, **kwargs)
        self._meta.get_field('product').choices = lazy(get_all_products,list)()

    def __str__(self) -> str:
        return f'{self.blend_number} ({self.blend_number_2}, Product = {self.product}, Tank {self.tank_number})'


