from django.forms import ModelForm
from .models import Blends


# Create the form class.
class BlendsForm(ModelForm):
    def __init__(self, *args, **kwargs):
        super(BlendsForm, self).__init__(*args, **kwargs)
        self.fields['demin_water_ph'].widget.attrs['min'] = 1
        self.fields['demin_water_ph'].widget.attrs['max'] = 14
        self.fields['sugar_ph'].widget.attrs['min'] = 1
        self.fields['sugar_ph'].widget.attrs['max'] = 14
        self.fields['product_ph'].widget.attrs['min'] = 1
        self.fields['product_ph'].widget.attrs['max'] = 14
        self.fields['alcohol_strength'].widget.attrs['min'] = 0
        self.fields['alcohol_strength'].widget.attrs['max'] = 100
        self.fields['product_alcoholic_strength'].widget.attrs['min'] = 0
        self.fields['product_alcoholic_strength'].widget.attrs['max'] = 100
        self.fields['product_color'].widget.attrs['min'] = 0
        self.fields['product_color'].widget.attrs['max'] = 100
        self.fields['demin_water_conductivity'].widget.attrs['min'] = 0.1
        self.fields['sugar_conductivity'].widget.attrs['min'] = 0.1
        self.fields['blend_number'].widget.attrs['pattern'] = "[0-9]{5,6}"
        #self.fields['product'].widget.choices = [(a.product_name_long, a.product_name_long) for a in ProductListModel.objects.all()]

    class Meta:
        model = Blends
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['result','status','username', 'datetime', 'has_dispute', 'dispute_status', 'disputes_status_list', 'is_checked', 'checked_comment', 'checked_by', 'checked_by_date', 'forms_images_uploaded', 'is_bottled', 'bottled_comment', 'bottled_recorded_by', 'bottled_by_date', 'is_approved', 'approver_comment', 'approved_by', 'approval_date']



class BlendsAdminForm(ModelForm):
    def __init__(self, *args, **kwargs):
        super(BlendsAdminForm, self).__init__(*args, **kwargs)
        self.fields['demin_water_ph'].widget.attrs['min'] = 1
        self.fields['demin_water_ph'].widget.attrs['max'] = 14
        self.fields['sugar_ph'].widget.attrs['min'] = 1
        self.fields['sugar_ph'].widget.attrs['max'] = 14
        self.fields['product_ph'].widget.attrs['min'] = 1
        self.fields['product_ph'].widget.attrs['max'] = 14
        self.fields['alcohol_strength'].widget.attrs['min'] = 0
        self.fields['alcohol_strength'].widget.attrs['max'] = 100
        self.fields['product_alcoholic_strength'].widget.attrs['min'] = 0
        self.fields['product_alcoholic_strength'].widget.attrs['max'] = 100
        self.fields['product_color'].widget.attrs['min'] = 0
        self.fields['product_color'].widget.attrs['max'] = 100
        self.fields['demin_water_conductivity'].widget.attrs['min'] = 0.1
        self.fields['sugar_conductivity'].widget.attrs['min'] = 0.1

        self.fields['blend_number'].widget.attrs['pattern'] = "[0-9]{5,6}"

    class Meta:
        model = Blends
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = []