from django.shortcuts import render, redirect

from blends.models import Blends
from .models import BlendFileModel
from .forms import BlendFileForm

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}

import logging
logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn

def joined_blends_dashboard(request):
    if 'username' in request.session:
        template_name = 'joined_blends_dashboard.html'

        if request.method == 'POST':
            pass
        else:
            joined_blends = BlendFileModel.objects.all().order_by('-id', '-datetime_created')
            return render(request, template_name, {'data':joined_blends, 'user_data':user_data_fxn(request) })


def join_blend(request, pk):
    if 'username' in request.session:
        template_name = 'join_blend.html'

        form = BlendFileForm(request.POST or None)
        blend = Blends.objects.get(pk=pk)

        if request.method == 'POST':
            return redirect('/')
        else:
            return render(request, template_name, {'d':blend, 'form':form, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')



def join_blend_helper(request):
    if 'username' in request.session:
        if request.method == 'POST':
            rows__length = request.POST.get('rows__length')
            blend_number = request.POST.get('blend_number')
            pkk = request.POST.get('pkk')
            blend = Blends.objects.get(pk=int(pkk))

            for r in range(1, int(rows__length)+ 1):
                line_sachet_area = request.POST.get(f'line_sachet_area{r}')
                line_sachet = request.POST.get(f'line_sachet{r}')
                comment= request.POST.get(f'comment{r}')
                if line_sachet_area == 'LINE':
                    line = line_sachet
                    sachet = 'NA'
                elif line_sachet_area == 'SACHET':
                    sachet = line_sachet
                    line = 'NA'
                B = BlendFileModel(blend = blend, blend_number = blend_number, line=line, sachet=sachet, line_sachet_area = line_sachet_area, line_sachet = int(line_sachet), comment = comment, created_by =request.session['username'])
                B.save()
                LatestUpdatesfxn(update=f"Blend {blend_number}, Joined to {line_sachet_area.upper()} {line_sachet}", blend_number=blend_number, created_by=request.session['username'])
            messages.success(request, 'Blend joined successfully')
            return redirect(f'/blend_info/{pkk}/')
        else:
            return redirect('/')
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')

