from django.db import models
from blends.models import Blends

line_sachet_Choices = (("LINE","LINE"), ("SACHET","SACHET"))

class BlendFileModel(models.Model):
    blend = models.ForeignKey(Blends, on_delete = models.CASCADE)
    blend_number = models.CharField(max_length=24)
    line_sachet_area = models.CharField(max_length=12, choices=line_sachet_Choices, default="")
    line = models.CharField(max_length=12, blank=True, default="NA")
    sachet = models.CharField(max_length=12, blank=True, default="NA")
    line_sachet = models.IntegerField()
    comment = models.TextField(blank=True, null=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)


    def __str__(self):
        return f"{self.blend_number}, title = {self.line_sachet_area} {self.line_sachet}"
