from django.shortcuts import render
from django.http import JsonResponse

from service_worker.models import LatestUpdateModel, ProductListModel

from blends.views import blend_number_generator

def latest_updates(request):
    latest_updates = LatestUpdateModel.objects.all().values().order_by('-id')
    return JsonResponse({'data':list(latest_updates)}, safe=False)


from blend_file.models import BlendFileModel


def get_blend_number_line_api(request):
    line = request.GET.get('line')
    product = request.GET.get('product')

    b = BlendFileModel.objects.filter(line__iexact=line).order_by('-id')

    for a in b:
        if a.blend.product == product:
            return JsonResponse({'blend_number':a.blend_number}, safe=False)
    return JsonResponse({'blend_number':''}, safe=False)


def get_all_product_name_api(request):
    products = [{'name': a.product_name_long, 'short_name':a.product_name_short, 'type':a.product_type} for a in ProductListModel.objects.all()]
    return JsonResponse({'products':products}, safe=False)



def get_product_type(request):
    product = request.GET.get('product')
    if product:
        prod = ProductListModel.objects.filter(product_name_long=product).values()
        blend_numbers = blend_number_generator(product)
        return JsonResponse({'product':prod[0], 'blend_numbers':blend_numbers}, safe=False)
    return JsonResponse({'product':''}, safe=False)


