from django.shortcuts import render, redirect

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

import logging

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn

from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger


def paginator(request, queryset):
    #dataLS = get_all_data_LSR(300)#dashboard max setting
    page = request.GET.get('page', 1)
    paginator = Paginator(queryset, 100)
    
    try:
        data = paginator.page(page)
    except PageNotAnInteger:
        data = paginator.page(1)
    except EmptyPage:
        data = paginator.page(paginator.num_pages)
    return data

def queryset_dictionary_ser(queryset):
    out = {}
    for k,v in queryset.items():
        out[k.replace('_', ' ').upper()] = v if v != '' else 'NA'
    return out


def administrator(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'administrator.html'

        if request.method == "POST":
            return redirect('/administrator/')
        else:
            return render(request, template_name, {'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')


from .models import Administrator_activities

def administrator_info(action, initial_data, final_data, model, username):
    act = Administrator_activities(action=action, initial_data=initial_data, final_data=final_data, model=model, username=username)
    act.save()
    return act.id


def administrator_activities_view(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'Administrator_activities.html'

        if request.method == 'POST':
            return redirect('/administrator/administrator_activities_view/')
        else:
            activities = Administrator_activities.objects.all().order_by('-id')
            acts = paginator(request, activities)
            return render(request, template_name, {'R':acts, 'user_data':user_data_fxn(request)})

    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')