from django.shortcuts import render, redirect
from users.forms import UserAdminForm
from users.models import Users
from blends.forms import BlendsAdminForm
from dispute.forms import DisputeAdminForm
from ingredients.forms import IngredientsAdminForm
from service_worker.forms import ProductListAdminForm

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

import logging

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn
from service_worker.views import LatestUpdatesfxn

from .views import paginator, queryset_dictionary_ser, administrator_info


def user_admin_list_fxn(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_list_fxn.html'

        if request.method == "POST":
            pass
        else:
            users = Users.objects.all().order_by('-id')
            return render(request, template_name, {'data':paginator(request, users), 'lk':'user', 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')




def user_admin_detail_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_detail_fxn.html'

        if request.method == "POST":
            pass
        else:
            u = Users.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':'user', 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')


def user_admin_update_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_update_fxn.html'
        u = Users.objects.get(pk=pk)

        if request.method == "POST":
            form = UserAdminForm(request.POST, instance=u)
            if form.is_valid():
                initial_data=u.values()
                form.save()
                administrator_info(action=f"{u.username} was Updated", initial_data=initial_data, final_data=f"{form}", model='Users', username=request.session['username'])
                return redirect(f'/administrator/user_admin_detail_fxn/{pk}')
        else:
            form = UserAdminForm(instance=u)
            return render(request, template_name, {'lk':'user', 'data':u, 'form':form, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')


def user_admin_delete_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_delete_fxn.html'
        u = Users.objects.get(pk=pk)

        if request.method == "POST":
            yes_no = request.POST.get('yes_no')
            pkk = request.POST.get('pkk')
            if yes_no == 'YES' and int(pkk) == pk:
                initial_data = f"{u.values()}"
                u.delete()
                administrator_info(action=f"{u.username} was Deleted", initial_data=initial_data, final_data="", model='Users', username=request.session['username'])
                messages.add_message(request, messages.SUCCESS, 'Record was deleted successfully!!!')
                return redirect('/administrator')
            return  redirect(f'/administrator/user_admin_delete_fxn/{u.id}')
        else:
            u = Users.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':'user', 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')



