from django.urls import path
from . import views, users_view, blends_view, ingredient_view, product_list_views, dispute_views, ingr_list_views

#/administrator
urlpatterns = [
    path('', views.administrator),
    path('administrator_activities_view/', views.administrator_activities_view),
    path('user_admin_list_fxn/', users_view.user_admin_list_fxn),
    path('user_admin_detail_fxn/<int:pk>/', users_view.user_admin_detail_fxn),
    path('user_admin_update_fxn/<int:pk>/', users_view.user_admin_update_fxn),
    path('user_admin_delete_fxn/<int:pk>/', users_view.user_admin_delete_fxn),

    path('blend_admin_list_fxn/', blends_view.blend_admin_list_fxn),
    path('blend_admin_detail_fxn/<int:pk>/', blends_view.blend_admin_detail_fxn),
    path('blend_admin_update_fxn/<int:pk>/', blends_view.blend_admin_update_fxn),
    path('blend_admin_delete_fxn/<int:pk>/', blends_view.blend_admin_delete_fxn),
    path('blend_admin_create_fxn/', blends_view.blend_admin_create_fxn),

    path('ingredient_admin_list_fxn/', ingredient_view.ingredient_admin_list_fxn),
    path('ingredient_admin_detail_fxn/<int:pk>/', ingredient_view.ingredient_admin_detail_fxn),
    path('ingredient_admin_update_fxn/<int:pk>/', ingredient_view.ingredient_admin_update_fxn),
    path('ingredient_admin_delete_fxn/<int:pk>/', ingredient_view.ingredient_admin_delete_fxn),
    path('ingredient_admin_view_ingredients_fxn/<int:pk>/', ingredient_view.ingredient_admin_view_ingredients_fxn),


    path('product_list_admin_list_fxn/', product_list_views.product_list_admin_list_fxn),
    path('product_list_admin_detail_fxn/<int:pk>/', product_list_views.product_list_admin_detail_fxn),
    path('product_list_admin_update_fxn/<int:pk>/', product_list_views.product_list_admin_update_fxn),
    path('product_list_admin_delete_fxn/<int:pk>/', product_list_views.product_list_admin_delete_fxn),

    path('dispute_admin_list_fxn/', dispute_views.dispute_admin_list_fxn),
    path('dispute_admin_detail_fxn/<int:pk>/', dispute_views.dispute_admin_detail_fxn),
    path('dispute_admin_update_fxn/<int:pk>/', dispute_views.dispute_admin_update_fxn),
    path('dispute_admin_delete_fxn/<int:pk>/', dispute_views.dispute_admin_delete_fxn),

    path('ingr_list_admin_list_fxn/', ingr_list_views.ingr_list_admin_list_fxn),
    path('ingr_list_admin_detail_fxn/<int:pk>/', ingr_list_views.ingr_list_admin_detail_fxn),
    path('ingr_list_admin_update_fxn/<int:pk>/', ingr_list_views.ingr_list_admin_update_fxn),
    path('ingr_list_admin_delete_fxn/<int:pk>/', ingr_list_views.ingr_list_admin_delete_fxn),
]