from django.shortcuts import render, redirect
from ingredients.forms import IngredientsAdminForm
from ingredients.models import Ingredients
from blends.models import Blends
from service_worker.forms import ProductListAdminForm

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

import logging

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn

from .views import paginator, queryset_dictionary_ser, administrator_info

lk = 'ingredient'


def ingredient_admin_list_fxn(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_list_fxn.html'

        if request.method == "POST":
            pass
        else:
            all_records = Ingredients.objects.all().order_by('-id')
            return render(request, template_name, {'data':paginator(request, all_records), 'lk':lk, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')




def ingredient_admin_detail_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_detail_fxn.html'

        if request.method == "POST":
            pass
        else:
            u = Ingredients.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':lk, 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')


def ingredient_admin_update_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_update_fxn.html'
        u = Ingredients.objects.get(pk=pk)

        if request.method == "POST":
            form = IngredientsAdminForm(request.POST, instance=u)
            if form.is_valid():
                initial_data=u.values()
                form.save()
                administrator_info(action=f"Ingredient {u.ingredient} was updated", initial_data=initial_data, final_data=f"{form}", model='Ingredients', username=request.session['username'])
                return redirect(f'/administrator/{lk}_admin_detail_fxn/{pk}')
        else:
            form = IngredientsAdminForm(instance=u)
            return render(request, template_name, {'lk':lk, 'data':u, 'form':form, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')


def ingredient_admin_delete_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_delete_fxn.html'
        u = Ingredients.objects.get(pk=pk)

        if request.method == "POST":
            yes_no = request.POST.get('yes_no')
            pkk = request.POST.get('pkk')
            if yes_no == 'YES' and int(pkk) == pk:
                initial_data = f"{u.values()}"
                u.delete()
                administrator_info(action=f"Ingredient {u.ingredient} was Deleted from {u.blend_number}", initial_data=initial_data, final_data="", model='blend', username=request.session['username'])
                messages.add_message(request, messages.SUCCESS, 'Record was deleted successfully!!!')
                return redirect('/administrator')
            return  redirect(f'/administrator/{lk}_admin_delete_fxn/{u.id}')
        else:
            u = Ingredients.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':lk, 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')



def ingredient_admin_view_ingredients_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/ingredient_admin_view_ingredients_fxn.html'
        u = Ingredients.objects.get(pk=pk)

        if request.method == "POST":
            pass
        else:
            blend = Blends.objects.get(pk=pk)
            u = Ingredients.objects.filter(blend=blend)
            return render(request, template_name, {'data':u, 'b':blend, 'lk':lk,  'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')

