from django.shortcuts import render, redirect
from blends.models import Blends
from dispute.forms import DisputeAdminForm
from dispute.models import DisputeModel

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

import logging

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn

from .views import paginator, queryset_dictionary_ser, administrator_info

lk = 'dispute'


def dispute_admin_list_fxn(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_list_fxn.html'

        if request.method == "POST":
            pass
        else:
            all_records = DisputeModel.objects.all().order_by('-id')
            return render(request, template_name, {'data':paginator(request, all_records), 'lk':lk, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')




def dispute_admin_detail_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_detail_fxn.html'

        if request.method == "POST":
            pass
        else:
            u = DisputeModel.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':lk, 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')


def dispute_admin_update_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_update_fxn.html'
        u = DisputeModel.objects.get(pk=pk)

        if request.method == "POST":
            form = DisputeAdminForm(request.POST, instance=u)
            if form.is_valid():
                initial_data=u.values()
                form.save()
                administrator_info(action=f"Dispute on Blend {u.blend.blend_number} Info was updated", initial_data=initial_data, final_data=f"{form}", model='DisputeModel', username=request.session['username'])
                return redirect(f'/administrator/{lk}_admin_detail_fxn/{pk}')
        else:
            form = DisputeAdminForm(instance=u)
            return render(request, template_name, {'lk':lk, 'data':u, 'form':form, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')


def dispute_admin_delete_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_delete_fxn.html'
        u = DisputeModel.objects.get(pk=pk)

        if request.method == "POST":
            yes_no = request.POST.get('yes_no')
            pkk = request.POST.get('pkk')
            if yes_no == 'YES' and int(pkk) == pk:
                initial_data = f"{u.values()}"
                u.delete()
                administrator_info(action=f"Dispute on Blend {u.blend.blend_number} was Deleted", initial_data=initial_data, final_data="", model='DisputeModel', username=request.session['username'])
                messages.add_message(request, messages.SUCCESS, 'Record was deleted successfully!!!')
                return redirect('/administrator')
            return  redirect(f'/administrator/{lk}_admin_delete_fxn/{u.id}')
        else:
            u = DisputeModel.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':lk, 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')

