from django.shortcuts import render, redirect
from blends.forms import BlendsAdminForm
from blends.models import Blends

from django.contrib import messages
from django.conf import settings
from django.core.mail import send_mail

import logging

from django.contrib.messages import constants
MESSAGE_TAGS = {constants.ERROR: 'danger',}


logging.basicConfig(filename="logger.log", format='%(asctime)s %(message)s', filemode='w')
logger = logging.getLogger()
logger.setLevel(logging.DEBUG)

from users.views import user_data_fxn

from .views import paginator, queryset_dictionary_ser, administrator_info


def blend_admin_list_fxn(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_list_fxn.html'

        if request.method == "POST":
            pass
        else:
            all_records = Blends.objects.all().order_by('-id')
            return render(request, template_name, {'data':paginator(request, all_records), 'lk':'blend', 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')




def blend_admin_detail_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_detail_fxn.html'

        if request.method == "POST":
            pass
        else:
            u = Blends.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':'blend', 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT AUTHORIZED FOR THIS ACTION!!!')
        return redirect('/login')


def blend_admin_update_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_update_fxn.html'
        #u = Blends.objects.get(pk=pk)
        u = Blends.objects.filter(pk=pk)

        if request.method == "POST":
            form = BlendsAdminForm(request.POST, instance=u.first())
            if form.is_valid():
                form.save()
                initial_data=u.values()[0]
                administrator_info(action=f"{u.first().blend_number} was Updated", initial_data=initial_data, final_data=f"{form}", model='Blends', username=request.session['username'])
                return redirect(f'/administrator/blend_admin_detail_fxn/{pk}')
        else:
            form = BlendsAdminForm(instance=u.first())
            return render(request, template_name, {'lk':'blend', 'data':u.first(), 'form':form, 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')


def blend_admin_delete_fxn(request, pk):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/admin_delete_fxn.html'
        #u = Blends.objects.get(pk=pk)
        u = Blends.objects.filter(pk=pk)

        if request.method == "POST":
            yes_no = request.POST.get('yes_no')
            pkk = request.POST.get('pkk')
            if yes_no == 'YES' and int(pkk) == pk:
                initial_data = f"{u.values()[0]}"
                u.delete()
                administrator_info(action=f"Blend {u.blend_number} was Deleted", initial_data=initial_data, final_data="", model='blend', username=request.session['username'])
                messages.add_message(request, messages.SUCCESS, 'Record was deleted successfully!!!')
                return redirect('/administrator')
            return  redirect(f'/administrator/blend_admin_delete_fxn/{u.id}')
        else:
            u = Blends.objects.filter(pk=pk)
            return render(request, template_name, {'data':queryset_dictionary_ser(u.values()[0]), 'lk':'blend', 'data2':u[0], 'user_data':user_data_fxn(request)})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')

from service_worker.models import ProductListModel

def blend_admin_create_fxn(request):
    if 'username' in request.session and request.session['role'] == 'SUPERADMIN':
        template_name = 'admin_pages/blend_admin_create_fxn.html'

        if request.method == "POST":
            form = BlendsAdminForm(request.POST)
            if form.is_valid():
                form.save()
                administrator_info(action=f"Blend {request.POST.get['blend_number']} was created", initial_data='NA', final_data=f"{form}", model='Blends', username=request.session['username'])
                return redirect(f'/administrator/blend_admin_list_fxn/')
        else:
            form = BlendsAdminForm()
            return render(request, template_name, {'lk':'blend','form':form, 'user_data':user_data_fxn(request), 'all_products':",".join([{'name':a.product_name_long, 'category':a.product_type} for a in ProductListModel.objects.all()])})
    else:
        messages.add_message(request, messages.ERROR, 'YOU ARE NOT LOGGED IN!!!')
        return redirect('/login')